/*
 * Decompiled with CFR 0.152.
 */
package org.fife.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public abstract class RPrintUtilities {
    private static int currentDocLineNumber;
    private static int numDocLines;
    private static Element rootElement;
    private static final char[] breakChars;
    private static int xOffset;
    private static int tabSizeInSpaces;
    private static FontMetrics fm;

    private static int getLineBreakPoint(String line, int maxCharsPerLine) {
        int breakPoint = -1;
        for (int i = 0; i < breakChars.length; ++i) {
            int breakCharPos = line.lastIndexOf(breakChars[i], maxCharsPerLine - 1);
            if (breakCharPos <= breakPoint) continue;
            breakPoint = breakCharPos;
        }
        return breakPoint == -1 ? maxCharsPerLine - 1 : breakPoint;
    }

    public static int printDocumentMonospaced(Graphics g, Document doc, int fontSize, int pageIndex, PageFormat pageFormat, int tabSize) {
        g.setColor(Color.BLACK);
        g.setFont(new Font("Monospaced", 0, fontSize));
        tabSizeInSpaces = tabSize;
        fm = g.getFontMetrics();
        int fontWidth = fm.charWidth('w');
        int fontHeight = fm.getHeight();
        int MAX_CHARS_PER_LINE = (int)pageFormat.getImageableWidth() / fontWidth;
        int MAX_LINES_PER_PAGE = (int)pageFormat.getImageableHeight() / fontHeight;
        int STARTING_LINE_NUMBER = MAX_LINES_PER_PAGE * pageIndex;
        xOffset = (int)pageFormat.getImageableX();
        int y = (int)pageFormat.getImageableY() + fm.getAscent() + 1;
        int numPrintedLines = 0;
        rootElement = doc.getDefaultRootElement();
        numDocLines = rootElement.getElementCount();
        for (currentDocLineNumber = 0; currentDocLineNumber < numDocLines; ++currentDocLineNumber) {
            String curLineString;
            Element currentLine = rootElement.getElement(currentDocLineNumber);
            int startOffs = currentLine.getStartOffset();
            try {
                curLineString = doc.getText(startOffs, currentLine.getEndOffset() - startOffs);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                return 1;
            }
            curLineString = curLineString.replaceAll("\n", "");
            if (tabSizeInSpaces == 0) {
                curLineString = curLineString.replaceAll("\t", "");
            } else {
                int tabIndex = curLineString.indexOf(9);
                while (tabIndex > -1) {
                    int spacesNeeded = tabSizeInSpaces - tabIndex % tabSizeInSpaces;
                    String replacementString = "";
                    for (int i = 0; i < spacesNeeded; ++i) {
                        replacementString = replacementString + ' ';
                    }
                    curLineString = curLineString.replaceFirst("\t", replacementString);
                    tabIndex = curLineString.indexOf(9);
                }
            }
            while (curLineString.length() > MAX_CHARS_PER_LINE) {
                if (++numPrintedLines > STARTING_LINE_NUMBER) {
                    g.drawString(curLineString.substring(0, MAX_CHARS_PER_LINE), xOffset, y);
                    y += fontHeight;
                    if (numPrintedLines == STARTING_LINE_NUMBER + MAX_LINES_PER_PAGE) {
                        return 0;
                    }
                }
                curLineString = curLineString.substring(MAX_CHARS_PER_LINE, curLineString.length());
            }
            if (++numPrintedLines <= STARTING_LINE_NUMBER) continue;
            g.drawString(curLineString, xOffset, y);
            y += fontHeight;
            if (numPrintedLines != STARTING_LINE_NUMBER + MAX_LINES_PER_PAGE) continue;
            return 0;
        }
        if (numPrintedLines > STARTING_LINE_NUMBER) {
            return 0;
        }
        return 1;
    }

    public static int printDocumentMonospacedWordWrap(Graphics g, Document doc, int fontSize, int pageIndex, PageFormat pageFormat, int tabSize) {
        g.setColor(Color.BLACK);
        g.setFont(new Font("Monospaced", 0, fontSize));
        tabSizeInSpaces = tabSize;
        fm = g.getFontMetrics();
        int fontWidth = fm.charWidth('w');
        int fontHeight = fm.getHeight();
        int MAX_CHARS_PER_LINE = (int)pageFormat.getImageableWidth() / fontWidth;
        int MAX_LINES_PER_PAGE = (int)pageFormat.getImageableHeight() / fontHeight;
        int STARTING_LINE_NUMBER = MAX_LINES_PER_PAGE * pageIndex;
        xOffset = (int)pageFormat.getImageableX();
        int y = (int)pageFormat.getImageableY() + fm.getAscent() + 1;
        int numPrintedLines = 0;
        rootElement = doc.getDefaultRootElement();
        numDocLines = rootElement.getElementCount();
        for (currentDocLineNumber = 0; currentDocLineNumber < numDocLines; ++currentDocLineNumber) {
            String curLineString;
            Element currentLine = rootElement.getElement(currentDocLineNumber);
            int startOffs = currentLine.getStartOffset();
            try {
                curLineString = doc.getText(startOffs, currentLine.getEndOffset() - startOffs);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                return 1;
            }
            curLineString = curLineString.replaceAll("\n", "");
            if (tabSizeInSpaces == 0) {
                curLineString = curLineString.replaceAll("\t", "");
            } else {
                int tabIndex = curLineString.indexOf(9);
                while (tabIndex > -1) {
                    int spacesNeeded = tabSizeInSpaces - tabIndex % tabSizeInSpaces;
                    String replacementString = "";
                    for (int i = 0; i < spacesNeeded; ++i) {
                        replacementString = replacementString + ' ';
                    }
                    curLineString = curLineString.replaceFirst("\t", replacementString);
                    tabIndex = curLineString.indexOf(9);
                }
            }
            while (curLineString.length() > MAX_CHARS_PER_LINE) {
                int breakPoint = RPrintUtilities.getLineBreakPoint(curLineString, MAX_CHARS_PER_LINE) + 1;
                if (++numPrintedLines > STARTING_LINE_NUMBER) {
                    g.drawString(curLineString.substring(0, breakPoint), xOffset, y);
                    y += fontHeight;
                    if (numPrintedLines == STARTING_LINE_NUMBER + MAX_LINES_PER_PAGE) {
                        return 0;
                    }
                }
                curLineString = curLineString.substring(breakPoint, curLineString.length());
            }
            if (++numPrintedLines <= STARTING_LINE_NUMBER) continue;
            g.drawString(curLineString, xOffset, y);
            y += fontHeight;
            if (numPrintedLines != STARTING_LINE_NUMBER + MAX_LINES_PER_PAGE) continue;
            return 0;
        }
        if (numPrintedLines > STARTING_LINE_NUMBER) {
            return 0;
        }
        return 1;
    }

    public static int printDocumentWordWrap(Graphics g, JTextComponent textComponent, Font font, int pageIndex, PageFormat pageFormat, int tabSize) {
        g.setColor(Color.BLACK);
        g.setFont(font != null ? font : textComponent.getFont());
        tabSizeInSpaces = tabSize;
        fm = g.getFontMetrics();
        int fontHeight = fm.getHeight();
        int LINE_LENGTH_IN_PIXELS = (int)pageFormat.getImageableWidth();
        int MAX_LINES_PER_PAGE = (int)pageFormat.getImageableHeight() / fontHeight;
        int STARTING_LINE_NUMBER = MAX_LINES_PER_PAGE * pageIndex;
        RPrintTabExpander tabExpander = new RPrintTabExpander();
        xOffset = (int)pageFormat.getImageableX();
        int y = (int)pageFormat.getImageableY() + fm.getAscent() + 1;
        int numPrintedLines = 0;
        Document doc = textComponent.getDocument();
        rootElement = doc.getDefaultRootElement();
        numDocLines = rootElement.getElementCount();
        currentDocLineNumber = 0;
        int startingOffset = 0;
        while (currentDocLineNumber < numDocLines) {
            Segment currentLineSeg = new Segment();
            Element currentLine = rootElement.getElement(currentDocLineNumber);
            int currentLineStart = currentLine.getStartOffset();
            int currentLineEnd = currentLine.getEndOffset();
            try {
                doc.getText(currentLineStart + startingOffset, currentLineEnd - (currentLineStart + startingOffset), currentLineSeg);
            }
            catch (BadLocationException ble) {
                System.err.println("BadLocationException in print (where there shouldn't be one!): " + ble);
                return 1;
            }
            currentLineSeg = RPrintUtilities.removeEndingWhitespace(currentLineSeg);
            int currentLineLengthInPixels = Utilities.getTabbedTextWidth(currentLineSeg, fm, 0, (TabExpander)tabExpander, 0);
            if (currentLineLengthInPixels <= LINE_LENGTH_IN_PIXELS) {
                ++currentDocLineNumber;
                startingOffset = 0;
            } else {
                int currentPos = -1;
                while (currentLineLengthInPixels > LINE_LENGTH_IN_PIXELS) {
                    currentLineSeg = RPrintUtilities.removeEndingWhitespace(currentLineSeg);
                    currentPos = -1;
                    String currentLineString = currentLineSeg.toString();
                    for (int i = 0; i < breakChars.length; ++i) {
                        int pos = currentLineString.lastIndexOf(breakChars[i]) + 1;
                        if (pos <= 0 || !(pos > currentPos & pos != currentLineString.length())) continue;
                        currentPos = pos;
                    }
                    if (currentPos == -1) {
                        currentPos = 0;
                        do {
                            ++currentPos;
                            try {
                                doc.getText(currentLineStart + startingOffset, currentPos, currentLineSeg);
                            }
                            catch (BadLocationException ble) {
                                System.err.println(ble);
                                return 1;
                            }
                        } while ((currentLineLengthInPixels = Utilities.getTabbedTextWidth(currentLineSeg, fm, 0, (TabExpander)tabExpander, 0)) <= LINE_LENGTH_IN_PIXELS);
                        --currentPos;
                    }
                    try {
                        doc.getText(currentLineStart + startingOffset, currentPos, currentLineSeg);
                    }
                    catch (BadLocationException ble) {
                        System.err.println("BadLocationException in print (a):");
                        System.err.println("==> currentLineStart: " + currentLineStart + "; startingOffset: " + startingOffset + "; currentPos: " + currentPos);
                        System.err.println("==> Range: " + (currentLineStart + startingOffset) + " - " + (currentLineStart + startingOffset + currentPos));
                        ble.printStackTrace();
                        return 1;
                    }
                    currentLineLengthInPixels = Utilities.getTabbedTextWidth(currentLineSeg, fm, 0, (TabExpander)tabExpander, 0);
                }
                startingOffset += currentPos;
            }
            if (++numPrintedLines <= STARTING_LINE_NUMBER) continue;
            Utilities.drawTabbedText(currentLineSeg, xOffset, y, g, (TabExpander)tabExpander, 0);
            y += fontHeight;
            if (numPrintedLines != STARTING_LINE_NUMBER + MAX_LINES_PER_PAGE) continue;
            return 0;
        }
        if (numPrintedLines > STARTING_LINE_NUMBER) {
            return 0;
        }
        return 1;
    }

    private static Segment removeEndingWhitespace(Segment segment) {
        int toTrim = 0;
        char currentChar = segment.setIndex(segment.getEndIndex() - 1);
        while ((currentChar == ' ' || currentChar == '\t') && currentChar != '\uffff') {
            ++toTrim;
            currentChar = segment.previous();
        }
        String stringVal2 = segment.toString();
        String newStringVal = stringVal2.substring(0, stringVal2.length() - toTrim);
        return new Segment(newStringVal.toCharArray(), 0, newStringVal.length());
    }

    static {
        breakChars = new char[]{' ', '\t', ',', '.', ';', '?', '!'};
    }

    private static class RPrintTabExpander
    implements TabExpander {
        RPrintTabExpander() {
        }

        public float nextTabStop(float x, int tabOffset) {
            if (tabSizeInSpaces == 0) {
                return x;
            }
            int tabSizeInPixels = tabSizeInSpaces * fm.charWidth(' ');
            int ntabs = ((int)x - xOffset) / tabSizeInPixels;
            return xOffset + (ntabs + 1) * tabSizeInPixels;
        }
    }
}

